/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.zcodeCommands;

import com.zortrax.g2z.domain.data.AxisFields;
import com.zortrax.g2z.domain.helper.ByteBuilder;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.io.IOException;
import java.math.BigDecimal;

public class CmdSetAsValue
implements ZCommand {
    private static final byte cmdNumber = 4;
    private final AxisFields axisFields;

    public CmdSetAsValue(AxisFields axisFields) {
        this.axisFields = axisFields;
    }

    public String toString() {
        StringBuilder string = new StringBuilder(String.format("%d SetAsValue (", (byte)4));
        if (this.axisFields.getAxisX().isPresent()) {
            string.append(String.format("X:%d", ((BigDecimal)this.axisFields.getAxisX().get()).movePointRight(3).intValue()));
        }
        if (this.axisFields.getAxisY().isPresent()) {
            string.append(String.format("Y:%d", ((BigDecimal)this.axisFields.getAxisY().get()).movePointRight(3).intValue()));
        }
        if (this.axisFields.getAxisZ().isPresent()) {
            string.append(String.format("Z:%d", ((BigDecimal)this.axisFields.getAxisZ().get()).movePointRight(3).intValue()));
        }
        if (this.axisFields.getAxisZ2().isPresent()) {
            string.append(String.format("Z2:%d", ((BigDecimal)this.axisFields.getAxisZ2().get()).movePointRight(3).intValue()));
        }
        if (this.axisFields.getExtrudeAmount().isPresent()) {
            string.append(String.format("E:%d", ((BigDecimal)this.axisFields.getExtrudeAmount().get()).movePointRight(3).intValue()));
        }
        if (this.axisFields.getFan1().isPresent()) {
            string.append(String.format("Fan1:%d", ((BigDecimal)this.axisFields.getFan1().get()).movePointRight(3).intValue()));
        }
        if (this.axisFields.getFan2().isPresent()) {
            string.append(String.format("Fan2:%d", ((BigDecimal)this.axisFields.getFan2().get()).movePointRight(3).intValue()));
        }
        string.append(")");
        return string.toString();
    }

    public byte[] toByteCommand() {
        try {
            return ByteBuilder.getBytesForAxisWithValues((byte)4, (AxisFields)this.axisFields, (byte[])new byte[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }
}

