/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.zcodeCommands;

import com.zortrax.g2z.domain.data.AxisFields;
import com.zortrax.g2z.domain.data.PrintingArea;
import com.zortrax.g2z.domain.helper.ByteBuilder;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Optional;

public class CmdPrintAndMove
implements ZCommand {
    private static final byte cmdNumber = 1;
    public static final String UNKNOWN_COMMENT = "Unknown";
    private byte printingArea = 1;
    private Optional<String> comment = Optional.of("Unknown");
    AxisFields axisFields;

    public CmdPrintAndMove(AxisFields axisFields, Optional<String> comment) {
        this.comment = comment;
        this.axisFields = axisFields;
    }

    public CmdPrintAndMove(AxisFields axisFields) {
        this.axisFields = axisFields;
    }

    public String toString() {
        AxisFields stepAxis = this.axisFields.convertToSteps();
        return String.format("%d PrintMove (%s%s)", (byte)1, this.comment.get(), this.convertToFanSpeed("Fan1", stepAxis.getFan1()) + this.convertToFanSpeed("Fan2", stepAxis.getFan2()) + this.convertToAxisMove("X", stepAxis.getAxisX()) + this.convertToAxisMove("Y", stepAxis.getAxisY()) + this.convertToAxisMove("Z", stepAxis.getAxisZ()) + this.convertToAxisMove("E", stepAxis.getExtrudeAmount()));
    }

    private String convertToAxisMove(String name, Optional<BigDecimal> axisX) {
        return axisX.map(bigDecimal -> bigDecimal.intValue()).map(value -> String.format(" %s:%d", name, value)).orElse("");
    }

    private String convertToFanSpeed(String name, Optional<BigDecimal> fanSpeed) {
        return fanSpeed.map(bigDecimal -> bigDecimal.intValue()).map(value -> String.format(" %s:%d", name, value)).orElse("");
    }

    public byte[] toByteCommand() {
        try {
            PrintingArea area = null;
            try {
                area = PrintingArea.valueOf((String)((String)this.comment.get()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                area = PrintingArea.Unknown;
            }
            return ByteBuilder.getBytesForAxisWithValues((byte)1, (AxisFields)this.axisFields, (byte[])new byte[]{area.getValue()});
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }
}

