/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.helper;

import com.zortrax.g2z.domain.data.EstimatePrintingTime;
import com.zortrax.g2z.domain.data.IDeviceConfig;
import com.zortrax.g2z.domain.data.ZCodeHeader;
import com.zortrax.g2z.domain.helper.IOutputFileGenerator;
import com.zortrax.g2z.domain.zcodeCommands.CmdPrintEnd;
import com.zortrax.g2z.domain.zcodeCommands.CmdReportProgress;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ZCodeFileGenerator
implements IOutputFileGenerator {
    private File file;
    private IDeviceConfig deviceConfig;

    public void setOutputFile(String filePath) {
        this.file = new File(filePath);
    }

    public void setOutputFile(File file) {
        this.file = file;
    }

    public void setPrinterConfig(IDeviceConfig deviceConfig) {
        this.deviceConfig = deviceConfig;
    }

    public void setPreviewFile(File file) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(List<byte[]> commands) throws FileNotFoundException {
        List zCodeOutputList = this.appendReportProgress(commands);
        ZCodeHeader zCodeHeader = new ZCodeHeader();
        zCodeHeader.setDeviceCongfig(this.deviceConfig);
        zCodeHeader.setCommandCount(zCodeOutputList.size());
        zCodeHeader.setPrintTime(EstimatePrintingTime.getInstance().getTotalPrintTime());
        byte[] headerBytes = zCodeHeader.toBytes();
        FileOutputStream output = new FileOutputStream(this.file, false);
        try {
            output.write(headerBytes);
            zCodeOutputList.forEach(v -> {
                try {
                    output.write((byte[])v);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                output.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private List<byte[]> appendReportProgress(List<byte[]> commands) {
        byte[] end;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int commandsCount = commands.size();
        int percentFactor = Math.max((int)Math.ceil(commandsCount / 100), 1);
        int lastProgress = 0;
        for (int i = 0; i < commandsCount; ++i) {
            if (i % percentFactor == 0 && lastProgress <= 100) {
                list.add(new CmdReportProgress(new BigDecimal(lastProgress++)).toByteCommand());
            }
            list.add(commands.get(i));
        }
        if (lastProgress == 100) {
            list.add(new CmdReportProgress(new BigDecimal(100)).toByteCommand());
        }
        if (!list.contains(end = new CmdPrintEnd().toByteCommand())) {
            list.add(end);
        }
        return list;
    }
}

