/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.helper;

import com.zortrax.g2z.domain.G2ZParser;
import com.zortrax.g2z.domain.data.AxisFields;
import com.zortrax.g2z.domain.data.AxisFix;
import com.zortrax.g2z.domain.data.CurrentDeviceConfig;
import com.zortrax.g2z.domain.data.DeviceConfigurations;
import com.zortrax.g2z.domain.data.EstimatePrintingTime;
import com.zortrax.g2z.domain.data.IDeviceConfig;
import com.zortrax.g2z.domain.helper.ZCodeFileGenerator;
import com.zortrax.g2z.domain.helper.ZCodeX2FileGenerator;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class GCodeFileParser
implements CommandLineRunner {
    File inputFile;
    File outputFile;
    File previewFile;
    private Scanner input;
    @Autowired
    private G2ZParser parser;
    private StringBuilder builder;
    int commandsNumber = 0;
    private boolean logOut = false;
    public static final String INPUT_FILE_COMMAND_ARG = "-i";
    public static final String OUTPUT_FILE_COMMAND_ARG = "-o";
    public static final String PREVIEW_FILE_COMMAND_ARG = "-p";
    public static final String DEVICE_NAME_COMMAND_ARG = "-d";
    public static final String HELP_COMMAND_ARG = "-h";
    public static final String LOG_COMMAND_ARG = "-l";
    public static final String ZCODE_READABLE_OUTPUT_COMMAND_ARG = "-zr";
    private StringBuilder logBuilder = new StringBuilder("");
    private boolean outputZCodeReadable = false;

    public void parse(String inputFileName, String outputFileName, File prevFile) throws FileNotFoundException {
        this.inputFile = new File(inputFileName);
        this.input = new Scanner(this.inputFile);
        ArrayList commands = new ArrayList();
        int i = 100;
        EstimatePrintingTime.getInstance().setDeviceConfig(CurrentDeviceConfig.getDeviceConfig());
        AxisFix.getInstance().setDeviceConfig(CurrentDeviceConfig.getDeviceConfig());
        AxisFields.setDeviceConfig((IDeviceConfig)CurrentDeviceConfig.getDeviceConfig());
        FileOutputStream fos = null;
        if (this.outputZCodeReadable) {
            String fileName = outputFileName + ".txt";
            fos = new FileOutputStream(fileName);
            try {
                fos.write("\n\r".getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        long lines = this.getLineCount(this.inputFile) - 1L;
        long currentLine = 0L;
        long oldProgress = -1L;
        while (this.input.hasNextLine()) {
            long progress;
            this.builder = new StringBuilder("");
            String gcodeLine = this.input.nextLine().trim() + " ";
            if (!gcodeLine.isEmpty()) {
                try {
                    List list = this.parser.parse(Arrays.asList(gcodeLine));
                    list.forEach(val -> commands.add(val.toByteCommand()));
                    this.commandsNumber += list.size();
                    if (fos != null) {
                        for (ZCommand zcode : list) {
                            try {
                                fos.write(zcode.toString().getBytes());
                                fos.write("\n\r".getBytes());
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    if (this.logOut) {
                        if (!list.isEmpty() && !gcodeLine.startsWith(";")) {
                            System.out.println(gcodeLine);
                        }
                        if (i < 100) {
                            list.forEach(v -> System.out.println(v.toString()));
                            list.forEach(v -> System.out.println(this.bytesToHex(v.toByteCommand())));
                        }
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            if (this.logOut || lines <= 0L || (progress = currentLine++ * 100L / lines) == oldProgress) continue;
            System.out.println(progress);
            oldProgress = progress;
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Object generator = CurrentDeviceConfig.getDeviceConfig().getPrinterType().isPrinterClassic() ? new ZCodeFileGenerator() : new ZCodeX2FileGenerator();
        generator.setPrinterConfig(CurrentDeviceConfig.getDeviceConfig());
        generator.setOutputFile(outputFileName);
        generator.setPreviewFile(prevFile);
        generator.generate(commands);
    }

    private String bytesToHex(byte[] in) {
        StringBuilder builder = new StringBuilder();
        builder.append("[ ");
        for (byte b : in) {
            builder.append(String.format("%02x ", b));
        }
        builder.append("]");
        return builder.toString();
    }

    public void run(String ... args) throws Exception {
        boolean parametersAreValid = this.setAndValidateParameters(args);
        if (parametersAreValid) {
            this.parse(this.inputFile.getAbsolutePath(), this.outputFile.getAbsolutePath(), this.previewFile);
        } else {
            System.out.println(this.logBuilder.toString());
        }
    }

    private boolean setAndValidateParameters(String[] args) {
        Boolean result = true;
        block18: for (String arg : args) {
            String[] commandPart = arg.split("=");
            switch (commandPart[0]) {
                case "-i": {
                    if (!new File(commandPart[1]).exists()) {
                        this.logBuilder.append("Input file (" + commandPart[1] + ") not exist!");
                        result = false;
                        continue block18;
                    }
                    this.inputFile = new File(commandPart[1]);
                    continue block18;
                }
                case "-o": {
                    if (commandPart[1] == "") {
                        this.logBuilder.append("Output file (" + commandPart[1] + ") not exist!");
                        continue block18;
                    }
                    this.outputFile = new File(commandPart[1]);
                    continue block18;
                }
                case "-p": {
                    if (commandPart[1] == "") {
                        this.logBuilder.append("Preview file (" + commandPart[1] + ") not exist!");
                        continue block18;
                    }
                    this.previewFile = new File(commandPart[1]);
                    continue block18;
                }
                case "-d": {
                    CurrentDeviceConfig.setDeviceConfig((IDeviceConfig)((IDeviceConfig)new DeviceConfigurations().get((Object)commandPart[1])));
                    if (CurrentDeviceConfig.getDeviceConfig() != null) continue block18;
                    this.logBuilder.append("Invalid device name. Available devices " + new DeviceConfigurations().toString());
                    return false;
                }
                case "-h": {
                    this.logBuilder.append("G2Z Help! \n");
                    this.logBuilder.append("USAGE:\n-i=fileName   //input gcode file\n-o=fileName   //output zcode file\n-p=fileName   //preview png file\n-d=device     //device name [M200]\n-h            //run help");
                    continue block18;
                }
                case "-l": {
                    this.logOut = true;
                    continue block18;
                }
                case "-zr": {
                    this.outputZCodeReadable = true;
                    continue block18;
                }
                default: {
                    this.logBuilder.append("UNKNOWN COMMAND " + commandPart[0]);
                }
            }
        }
        if (this.inputFile == null || this.outputFile == null || CurrentDeviceConfig.getDeviceConfig() == null) {
            return false;
        }
        return result;
    }

    private long getLineCount(File inputFile) {
        long l;
        FileReader inFile = new FileReader(inputFile);
        try {
            LineNumberReader count = new LineNumberReader(inFile);
            l = count.lines().count();
        }
        catch (Throwable throwable) {
            try {
                try {
                    inFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return 0L;
            }
        }
        inFile.close();
        return l;
    }
}

