/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.helper;

import com.zortrax.g2z.domain.data.AxisFields;
import com.zortrax.g2z.domain.helper.ByteCollector;
import com.zortrax.g2z.domain.helper.CRC8;
import com.zortrax.g2z.domain.helper.IBinaryConverter;
import com.zortrax.g2z.domain.helper.LittleEndianConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.stream.Stream;

/*
 * Exception performing whole class analysis ignored.
 */
public class ByteBuilder {
    public static final int CMD_NUMBER_AND_BYTE_COUNT_LENGTH = 2;
    public static final int EMPTY = -1;
    private static ByteArrayOutputStream output = new ByteArrayOutputStream();
    private static byte commandNumber;

    public static byte[] getBytesForAxisWithValues(byte cmdNumber, AxisFields axisFields, byte ... additionalValues) throws IOException {
        AxisFields axisFieldsInSteps = axisFields.convertToSteps();
        commandNumber = cmdNumber;
        byte axisBitField = ByteBuilder.getBitField((AxisFields)axisFieldsInSteps);
        byte[] values = ByteBuilder.getValuesAsByte((AxisFields)axisFieldsInSteps);
        byte byteCount = Integer.valueOf(3 + values.length + additionalValues.length).byteValue();
        ByteArrayOutputStream output = new ByteArrayOutputStream(byteCount + 1);
        output.write(byteCount);
        output.write(commandNumber);
        for (byte value : additionalValues) {
            output.write(value);
        }
        output.write(axisBitField);
        output.write(values);
        output.write(CRC8.calculateCrc((byte[])output.toByteArray()));
        return output.toByteArray();
    }

    public static byte[] getBytesForAxis(byte cmdNumber, AxisFields axisFields) throws IOException {
        AxisFields axisFieldsInSteps = axisFields.convertToSteps();
        commandNumber = cmdNumber;
        byte axisBitField = ByteBuilder.getBitField((AxisFields)axisFieldsInSteps);
        int byteCount = 3;
        ByteArrayOutputStream output = new ByteArrayOutputStream(byteCount + 1);
        output.write(byteCount);
        output.write(commandNumber);
        output.write(axisBitField);
        output.write(CRC8.calculateCrc((byte[])output.toByteArray()));
        return output.toByteArray();
    }

    public static byte[] getBytes(byte cmdNumber, byte ... values) throws IOException {
        commandNumber = cmdNumber;
        byte byteCount = (byte)(2 + values.length);
        ByteArrayOutputStream output = new ByteArrayOutputStream(byteCount + 1);
        output.write(byteCount);
        output.write(commandNumber);
        for (byte value : values) {
            output.write(value);
        }
        output.write(CRC8.calculateCrc((byte[])output.toByteArray()));
        return output.toByteArray();
    }

    public static byte[] getBytesForIntegerWithId(byte cmdNumber, int id, BigDecimal bigDecimal) throws IOException {
        commandNumber = cmdNumber;
        byte[] values = ByteBuilder.getValuesAsByte((BigDecimal)bigDecimal);
        byte byteCount = (byte)(2 + (id != -1 ? 1 : 0) + values.length);
        ByteArrayOutputStream output = new ByteArrayOutputStream(byteCount + 1);
        output.write(byteCount);
        output.write(commandNumber);
        if (id != -1) {
            output.write((byte)id);
        }
        for (byte value : values) {
            output.write(value);
        }
        output.write(CRC8.calculateCrc((byte[])output.toByteArray()));
        return output.toByteArray();
    }

    public static byte[] getBytesForCleanCommand(byte cmdNumber) throws IOException {
        byte commandNumber = cmdNumber;
        int byteCount = 2;
        ByteArrayOutputStream output = new ByteArrayOutputStream(byteCount + 1);
        output.write(byteCount);
        output.write(commandNumber);
        output.write(CRC8.calculateCrc((byte[])output.toByteArray()));
        return output.toByteArray();
    }

    private static byte[] getValuesAsByte(AxisFields axisFields) {
        return (byte[])Stream.of(axisFields.getAxisX(), axisFields.getAxisY(), axisFields.getAxisZ(), axisFields.getExtrudeAmount(), axisFields.getFan1(), axisFields.getFan2(), axisFields.getAxisZ2()).filter(Optional::isPresent).map(Optional::get).collect(new ByteCollector((IBinaryConverter)new LittleEndianConverter()).toArray());
    }

    private static byte[] getValuesAsByte(BigDecimal value) {
        return (byte[])Stream.of(value).collect(new ByteCollector((IBinaryConverter)new LittleEndianConverter()).toArray());
    }

    private static byte getBitField(AxisFields axisFields) {
        int sum = Stream.of(axisFields.getAxisX().map(v -> 1), axisFields.getAxisY().map(v -> 2), axisFields.getAxisZ().map(v -> 4), axisFields.getExtrudeAmount().map(v -> 8), axisFields.getFan1().map(v -> 16), axisFields.getFan2().map(v -> 32), axisFields.getAxisZ2().map(v -> 64)).filter(Optional::isPresent).map(Optional::get).mapToInt(Integer::intValue).sum();
        return Integer.valueOf(sum).byteValue();
    }
}

