/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.data;

import com.zortrax.g2z.domain.data.IDeviceConfig;
import com.zortrax.g2z.domain.data.Preview;
import com.zortrax.g2z.domain.data.metadata.ZCodeMetadataJson;
import com.zortrax.g2z.domain.helper.BinaryUtils;
import java.io.File;
import java.io.IOException;

public class ZCodeX2Header {
    private ZCodeMetadataJson metadataJson = new ZCodeMetadataJson();
    private Preview preview = new Preview();

    public ZCodeX2Header setDeviceCongfig(IDeviceConfig IDeviceConfig2) {
        this.metadataJson.setDeviceConfig(IDeviceConfig2);
        return this;
    }

    public ZCodeX2Header setPrintTime(int printTime) {
        this.metadataJson.setPrintTime(printTime);
        return this;
    }

    public ZCodeX2Header setCommandCount(int commandCount) {
        this.metadataJson.setCommandCount(commandCount);
        return this;
    }

    public ZCodeX2Header setPreview(File file) throws IOException {
        this.preview.setPreviewFile(file);
        return this;
    }

    public ZCodeX2Header setTotalLayersCount(int layers) {
        this.metadataJson.setTotalLayersCount(layers);
        return this;
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[this.metadataJson.toString().length() + 4 + this.preview.toBytes().length + 4];
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)0, (int)4, (int)this.metadataJson.toString().length());
        BinaryUtils.writeStringToByteArray((byte[])bytes, (int)4, (int)this.metadataJson.toString().length(), (String)this.metadataJson.toString());
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)(this.metadataJson.toString().length() + 4), (int)4, (int)this.preview.toBytes().length);
        System.arraycopy(this.preview.toBytes(), 0, bytes, this.metadataJson.toString().length() + 8, this.preview.toBytes().length);
        return bytes;
    }
}

