/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.data;

import com.zortrax.g2z.domain.data.IDeviceConfig;
import com.zortrax.g2z.domain.helper.BinaryUtils;
import com.zortrax.g2z.domain.helper.CRC8;
import java.util.Arrays;
import java.util.Objects;

public class ZCodeHeader {
    final String description = "ZCode";
    final int version = 1;
    final int subVersion = 0;
    int stepsPerMmX;
    int stepsPerMmY;
    int stepsPerMmZ;
    int stepsPerMmE;
    int stepsPerMmFan1 = 1;
    int stepsPerMmFan2 = 1;
    int stepsPerMmZ2;
    final int stepsPerMmTmp4 = 0;
    int commandCount;
    int printTime = 0;
    final int minFWVersion = 0;
    final int minFWSubVersion1 = 0;
    final int minFWSubVersion2 = 0;
    int hardwareVersion;
    int printingProfile = 101;
    final int layerThickness = 0;
    final int quality = 1;
    final int infill = 0;
    final int supportAngle = 0;
    final int supportLite = 0;
    final int softwareVersionA = 1;
    final int softwareVersionB = 12;
    final int softwareVersionC = 1;
    final int softwareVersionD = 0;
    final int raftLayers = 6;
    final int materialLength = 1;
    final int supportLength = 1;
    final int imageDataSize = 0;
    final int supportMaterial = 1;
    final int nozzleDiameter = 0;
    int CRC;

    public ZCodeHeader setDeviceCongfig(IDeviceConfig IDeviceConfig2) {
        this.hardwareVersion = IDeviceConfig2.getPrinterType().getPrinterId();
        this.stepsPerMmX = IDeviceConfig2.getStepsPerMmX();
        this.stepsPerMmY = IDeviceConfig2.getStepsPerMmY();
        this.stepsPerMmZ = IDeviceConfig2.getStepsPerMmZ();
        this.stepsPerMmE = IDeviceConfig2.getStepsPerMmE();
        this.stepsPerMmFan1 = IDeviceConfig2.getStepsPerMmFan1();
        this.stepsPerMmFan2 = IDeviceConfig2.getStepsPerMmFan2();
        this.stepsPerMmZ2 = IDeviceConfig2.getStepsPerMmZ2();
        return this;
    }

    public ZCodeHeader setPrintTime(int printTime) {
        this.printTime = printTime;
        return this;
    }

    public ZCodeHeader setCommandCount(int commandCount) {
        this.commandCount = commandCount;
        return this;
    }

    public ZCodeHeader setCrc(int crc) {
        this.CRC = crc;
        return this;
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[128];
        Objects.requireNonNull(this);
        BinaryUtils.writeStringToByteArray((byte[])bytes, (int)0, (int)16, (String)"ZCode");
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)16, (int)1, (int)1);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)17, (int)1, (int)0);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)18, (int)4, (int)this.stepsPerMmX);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)22, (int)4, (int)this.stepsPerMmY);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)26, (int)4, (int)this.stepsPerMmZ);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)30, (int)4, (int)this.stepsPerMmE);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)34, (int)4, (int)this.stepsPerMmFan1);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)38, (int)4, (int)this.stepsPerMmFan2);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)42, (int)4, (int)this.stepsPerMmZ2);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)46, (int)4, (int)0);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)50, (int)4, (int)this.commandCount);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)54, (int)4, (int)this.printTime);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)58, (int)1, (int)0);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)59, (int)1, (int)0);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)60, (int)1, (int)0);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)61, (int)1, (int)this.hardwareVersion);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)62, (int)1, (int)this.printingProfile);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)63, (int)1, (int)0);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)64, (int)1, (int)1);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)65, (int)1, (int)0);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)66, (int)1, (int)0);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)67, (int)1, (int)0);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)68, (int)1, (int)1);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)69, (int)1, (int)12);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)70, (int)1, (int)1);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)71, (int)1, (int)0);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)72, (int)1, (int)6);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)73, (int)4, (int)1);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)77, (int)4, (int)1);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)81, (int)4, (int)0);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)85, (int)1, (int)1);
        Objects.requireNonNull(this);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)86, (int)1, (int)0);
        byte[] out = Arrays.copyOf(bytes, 127);
        BinaryUtils.writeIntToByteArray((byte[])bytes, (int)127, (int)1, (int)CRC8.calculateCrc((byte[])out));
        return bytes;
    }
}

