/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.data;

import com.zortrax.g2z.domain.data.IDeviceConfig;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Optional;

public class EstimatePrintingTime {
    private BigDecimal totalPrintTime = BigDecimal.ZERO;
    private BigDecimal currentX = BigDecimal.ZERO;
    private BigDecimal currentY = BigDecimal.ZERO;
    private BigDecimal currentZ = BigDecimal.ZERO;
    private BigDecimal currentE = BigDecimal.ZERO;
    private BigDecimal maxFeedrateXY = BigDecimal.valueOf(200L);
    private BigDecimal maxFeedrateZ = BigDecimal.valueOf(20L);
    private BigDecimal maxFeedrateE = BigDecimal.valueOf(45L);
    private BigDecimal maxAccXY = BigDecimal.valueOf(3000L);
    private BigDecimal maxAccZ = BigDecimal.valueOf(50L);
    private BigDecimal maxAccE = BigDecimal.valueOf(4000L);
    private BigDecimal currentF = BigDecimal.valueOf(200L);
    private BigDecimal currentAcc = BigDecimal.valueOf(3000L);
    private BigDecimal currentExtruder = BigDecimal.valueOf(0L);
    private boolean relative = false;
    private boolean relativeE = false;
    private static EstimatePrintingTime instance = null;

    private EstimatePrintingTime() {
    }

    public static EstimatePrintingTime getInstance() {
        if (instance == null) {
            instance = new EstimatePrintingTime();
        }
        return instance;
    }

    public void setDeviceConfig(IDeviceConfig dc) {
        this.currentF = this.maxFeedrateXY = BigDecimal.valueOf(dc.getMaxXYFeedrate());
        this.maxFeedrateZ = BigDecimal.valueOf(dc.getMaxZFeedrate());
        this.maxFeedrateE = BigDecimal.valueOf(dc.getMaxEFeedrate());
        this.currentAcc = this.maxAccXY = BigDecimal.valueOf(dc.maxAccXY());
        this.maxAccZ = BigDecimal.valueOf(dc.maxAccZ());
        this.maxAccE = BigDecimal.valueOf(dc.maxAccE());
    }

    private BigDecimal sqrt(BigDecimal value) {
        BigDecimal x = new BigDecimal(Math.sqrt(value.doubleValue()));
        return x.add(new BigDecimal(value.subtract(x.multiply(x)).doubleValue() / (x.doubleValue() * 2.0)));
    }

    private BigDecimal acc_move(BigDecimal dist, BigDecimal v, BigDecimal a, BigDecimal maxacc) {
        BigDecimal acc = a;
        if (acc.compareTo(BigDecimal.ZERO) == 0) {
            acc = maxacc;
        }
        BigDecimal half_dist = dist.divide(BigDecimal.valueOf(2.0), 2, RoundingMode.HALF_UP);
        BigDecimal t_init = v.divide(acc, 2, RoundingMode.HALF_UP);
        BigDecimal dx_init = v.multiply(t_init.multiply(BigDecimal.valueOf(0.5)));
        BigDecimal t = BigDecimal.ZERO;
        if (half_dist.compareTo(dx_init) == 0 || half_dist.compareTo(dx_init) == 1) {
            half_dist = half_dist.subtract(v.multiply(t_init.multiply(BigDecimal.valueOf(0.5))));
            t = t.add(t_init);
        }
        t = t.add(half_dist.divide(v, 2, RoundingMode.HALF_UP));
        return t.multiply(BigDecimal.valueOf(2.0));
    }

    public void setXYZEF(Optional<BigDecimal> x, Optional<BigDecimal> y, Optional<BigDecimal> z, Optional<BigDecimal> e, Optional<BigDecimal> f) {
        BigDecimal xy_move;
        BigDecimal x_dist = BigDecimal.ZERO;
        BigDecimal y_dist = BigDecimal.ZERO;
        BigDecimal z_dist = BigDecimal.ZERO;
        BigDecimal e_dist = BigDecimal.ZERO;
        if (f.isPresent()) {
            this.currentF = f.get().divide(BigDecimal.valueOf(60L), 2, RoundingMode.HALF_UP);
        }
        if (x.isPresent()) {
            if (this.relative) {
                x_dist = x.get().abs();
                this.currentX = this.currentX.add(x.get());
            } else {
                x_dist = x.get().subtract(this.currentX).abs();
                this.currentX = x.get();
            }
        }
        if (y.isPresent()) {
            if (this.relative) {
                y_dist = y.get().abs();
                this.currentY = this.currentY.add(y.get());
            } else {
                y_dist = y.get().subtract(this.currentY).abs();
                this.currentY = y.get();
            }
        }
        if (z.isPresent()) {
            if (this.relative) {
                z_dist = z.get().abs();
                this.currentZ = this.currentZ.add(z.get());
            } else {
                z_dist = z.get().subtract(this.currentZ).abs();
                this.currentZ = z.get();
            }
        }
        if (e.isPresent()) {
            if (this.relativeE) {
                e_dist = e.get().abs();
                this.currentE = this.currentE.add(e.get());
            } else {
                e_dist = e.get().subtract(this.currentE).abs();
                this.currentE = e.get();
            }
        }
        if (x_dist.compareTo(BigDecimal.ZERO) == 0 && y_dist.compareTo(BigDecimal.ZERO) == 0) {
            xy_move = BigDecimal.ZERO;
        } else {
            xy_move = x_dist.pow(2).add(y_dist.pow(2));
            xy_move = this.sqrt(xy_move);
        }
        if (xy_move.compareTo(BigDecimal.ZERO) == 1) {
            this.totalPrintTime = this.totalPrintTime.add(this.acc_move(xy_move, this.currentF.min(this.maxFeedrateXY), this.currentAcc.min(this.maxAccXY), this.maxAccXY));
        } else if (e_dist.compareTo(BigDecimal.ZERO) == 1) {
            this.totalPrintTime = this.totalPrintTime.add(this.acc_move(e_dist, this.currentF.min(this.maxFeedrateE), this.currentAcc.min(this.maxAccE), this.maxAccE));
        }
        if (z_dist.compareTo(BigDecimal.ZERO) == 1) {
            this.totalPrintTime = this.totalPrintTime.add(this.acc_move(z_dist, this.currentF.min(this.maxFeedrateZ), this.currentAcc.min(this.maxAccZ), this.maxAccZ));
        }
    }

    public int getTotalPrintTime() {
        return this.totalPrintTime.intValue();
    }

    public void addDelay(BigDecimal s) {
        this.totalPrintTime = this.totalPrintTime.add(s);
    }

    public void selectExtruder(BigDecimal t) {
        if (this.currentExtruder != t) {
            this.currentExtruder = t;
        }
    }

    public void setRelative(boolean relative) {
        this.relative = relative;
        this.relativeE = relative;
    }

    public void setRelativeE(boolean relative) {
        this.relativeE = relative;
    }

    public void setCurrentXYZE(Optional<BigDecimal> x, Optional<BigDecimal> y, Optional<BigDecimal> z, Optional<BigDecimal> e) {
        if (x.isPresent()) {
            this.currentX = x.get();
        }
        if (y.isPresent()) {
            this.currentY = y.get();
        }
        if (z.isPresent()) {
            this.currentZ = z.get();
        }
        if (e.isPresent()) {
            this.currentE = e.get();
        }
    }
}

