/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.data;

import com.zortrax.g2z.domain.data.IDeviceConfig;
import java.math.BigDecimal;
import java.util.Optional;

public class AxisFix {
    private BigDecimal currentX = BigDecimal.ZERO;
    private BigDecimal currentY = BigDecimal.ZERO;
    private BigDecimal currentZ = BigDecimal.ZERO;
    private BigDecimal currentE = BigDecimal.ZERO;
    private boolean relative = false;
    private boolean relativeE = false;
    private boolean devRelative = false;
    private boolean devRelativeE = false;
    private static AxisFix instance = null;

    private AxisFix() {
    }

    public static AxisFix getInstance() {
        if (instance == null) {
            instance = new AxisFix();
        }
        return instance;
    }

    public void setDeviceConfig(IDeviceConfig dc) {
        this.devRelative = dc.getIsRelative();
        this.devRelativeE = dc.getIsERelative();
    }

    public void setRelative(boolean relative) {
        this.relative = relative;
        this.relativeE = relative;
    }

    public void setRelativeE(boolean relativeE) {
        this.relativeE = relativeE;
    }

    public Optional<BigDecimal> axisXFix(Optional<BigDecimal> x) {
        Optional<BigDecimal> ret = x;
        if (x.isPresent() && this.relative != this.devRelative) {
            if (this.relative) {
                this.currentX = this.currentX.add(x.get());
                ret = Optional.ofNullable(this.currentX);
            } else {
                ret = Optional.ofNullable(x.get().subtract(this.currentX));
                this.currentX = x.get();
            }
        }
        return ret;
    }

    public Optional<BigDecimal> axisYFix(Optional<BigDecimal> y) {
        Optional<BigDecimal> ret = y;
        if (y.isPresent() && this.relative != this.devRelative) {
            if (this.relative) {
                this.currentY = this.currentY.add(y.get());
                ret = Optional.ofNullable(this.currentY);
            } else {
                ret = Optional.ofNullable(y.get().subtract(this.currentY));
                this.currentY = y.get();
            }
        }
        return ret;
    }

    public Optional<BigDecimal> axisZFix(Optional<BigDecimal> z) {
        Optional<BigDecimal> ret = z;
        if (z.isPresent() && this.relative != this.devRelative) {
            if (this.relative) {
                this.currentZ = this.currentZ.add(z.get());
                ret = Optional.ofNullable(this.currentZ);
            } else {
                ret = Optional.ofNullable(z.get().subtract(this.currentZ));
                this.currentZ = z.get();
            }
        }
        return ret;
    }

    public Optional<BigDecimal> axisEFix(Optional<BigDecimal> e) {
        Optional<BigDecimal> ret = e;
        if (e.isPresent() && this.relativeE != this.devRelativeE) {
            if (this.relativeE) {
                this.currentE = this.currentE.add(e.get());
                ret = Optional.ofNullable(this.currentE);
            } else {
                ret = Optional.ofNullable(e.get().subtract(this.currentE));
                this.currentE = e.get();
            }
        }
        return ret;
    }

    public void setCurrentXYZE(Optional<BigDecimal> x, Optional<BigDecimal> y, Optional<BigDecimal> z, Optional<BigDecimal> e) {
        if (x.isPresent()) {
            this.currentX = x.get();
        }
        if (y.isPresent()) {
            this.currentY = y.get();
        }
        if (z.isPresent()) {
            this.currentZ = z.get();
        }
        if (e.isPresent()) {
            this.currentE = e.get();
        }
    }
}

