/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.data;

import com.zortrax.g2z.domain.data.AxisFix;
import com.zortrax.g2z.domain.data.IDeviceConfig;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.stream.Stream;

public class AxisFields {
    private static IDeviceConfig IDeviceConfig;
    private Optional<BigDecimal> axisX = Optional.empty();
    private Optional<BigDecimal> axisY = Optional.empty();
    private Optional<BigDecimal> axisZ = Optional.empty();
    private Optional<BigDecimal> axisZ2 = Optional.empty();
    private Optional<BigDecimal> extrudeAmount = Optional.empty();
    private Optional<BigDecimal> fan1 = Optional.empty();
    private Optional<BigDecimal> fan2 = Optional.empty();

    public AxisFields() {
    }

    public static void setDeviceConfig(IDeviceConfig dc) {
        IDeviceConfig = dc;
    }

    public AxisFields(BigDecimal axisX, BigDecimal axisY, BigDecimal axisZ, BigDecimal axisZ2, BigDecimal extrudeAmount, BigDecimal fan1, BigDecimal fan2) {
        this.axisX = Optional.ofNullable(axisX);
        this.axisY = Optional.ofNullable(axisY);
        this.axisZ = Optional.ofNullable(axisZ);
        this.axisZ2 = Optional.ofNullable(axisZ2);
        this.extrudeAmount = Optional.ofNullable(extrudeAmount);
        this.fan1 = Optional.ofNullable(fan1);
        this.fan2 = Optional.ofNullable(fan2);
    }

    public Optional<BigDecimal> getAxisX() {
        return this.axisX;
    }

    public AxisFields setAxisX(Optional<BigDecimal> axisX) {
        this.axisX = axisX;
        return this;
    }

    public AxisFields setAxisX(BigDecimal axisX) {
        this.axisX = Optional.ofNullable(axisX);
        return this;
    }

    public Optional<BigDecimal> getAxisY() {
        return this.axisY;
    }

    public AxisFields setAxisY(Optional<BigDecimal> axisY) {
        this.axisY = axisY;
        return this;
    }

    public AxisFields setAxisY(BigDecimal axisY) {
        this.axisY = Optional.ofNullable(axisY);
        return this;
    }

    public Optional<BigDecimal> getAxisZ() {
        return this.axisZ;
    }

    public AxisFields setAxisZ(Optional<BigDecimal> axisZ) {
        this.axisZ = axisZ;
        return this;
    }

    public AxisFields setAxisZ(BigDecimal axisZ) {
        this.axisZ = Optional.ofNullable(axisZ);
        return this;
    }

    public Optional<BigDecimal> getAxisZ2() {
        return this.axisZ2;
    }

    public AxisFields setAxisZ2(Optional<BigDecimal> axisZ2) {
        this.axisZ2 = axisZ2;
        return this;
    }

    public AxisFields setAxisZ2(BigDecimal axisZ2) {
        this.axisZ2 = Optional.ofNullable(axisZ2);
        return this;
    }

    public Optional<BigDecimal> getExtrudeAmount() {
        return this.extrudeAmount;
    }

    public AxisFields setExtrudeAmount(Optional<BigDecimal> extrudeAmount) {
        this.extrudeAmount = extrudeAmount;
        return this;
    }

    public AxisFields setExtrudeAmount(BigDecimal extrudeAmount) {
        this.extrudeAmount = Optional.ofNullable(extrudeAmount);
        return this;
    }

    public Optional<BigDecimal> getFan1() {
        return this.fan1;
    }

    public AxisFields setFan1(Optional<BigDecimal> fan1) {
        this.fan1 = fan1;
        return this;
    }

    public AxisFields setFan1(BigDecimal fan1) {
        this.fan1 = Optional.ofNullable(fan1);
        return this;
    }

    public Optional<BigDecimal> getFan2() {
        return this.fan2;
    }

    public AxisFields setFan2(Optional<BigDecimal> fan2) {
        this.fan2 = fan2;
        return this;
    }

    public AxisFields setFan2(BigDecimal fan2) {
        this.fan2 = Optional.ofNullable(fan2);
        return this;
    }

    public Boolean anyAxisExist() {
        return Stream.of(this.axisX, this.axisY, this.axisZ, this.axisZ2, this.extrudeAmount, this.fan1, this.fan2).anyMatch(bigDecimal -> bigDecimal.isPresent());
    }

    public AxisFields convertToSteps() {
        return new AxisFields().setAxisX(this.convertToStep(this.axisX, IDeviceConfig.getStepsPerMmX())).setAxisY(this.convertToStep(this.axisY, IDeviceConfig.getStepsPerMmY())).setAxisZ(this.convertToStep(this.axisZ, IDeviceConfig.getStepsPerMmZ())).setExtrudeAmount(this.convertToStep(this.extrudeAmount, IDeviceConfig.getStepsPerMmE())).setFan1(this.convertToStep(this.fan1, IDeviceConfig.getStepsPerMmFan1())).setFan2(this.convertToStep(this.fan2, IDeviceConfig.getStepsPerMmFan2())).setAxisZ2(this.convertToStep(this.axisZ2, IDeviceConfig.getStepsPerMmZ2()));
    }

    public AxisFields setAxisXFix(Optional<BigDecimal> x) {
        this.axisX = AxisFix.getInstance().axisXFix(x);
        return this;
    }

    public AxisFields setAxisYFix(Optional<BigDecimal> y) {
        this.axisY = AxisFix.getInstance().axisYFix(y);
        return this;
    }

    public AxisFields setAxisZFix(Optional<BigDecimal> z) {
        this.axisZ = AxisFix.getInstance().axisZFix(z);
        return this;
    }

    public AxisFields setExtrudeAmountFix(Optional<BigDecimal> e) {
        this.extrudeAmount = AxisFix.getInstance().axisEFix(e);
        return this;
    }

    private Optional<BigDecimal> convertToStep(Optional<BigDecimal> bigDecimal, int stepsPerMm) {
        if (!bigDecimal.isPresent()) {
            return Optional.empty();
        }
        BigDecimal value = bigDecimal.get();
        return Optional.of(new BigDecimal(Math.round(value.floatValue() * (float)stepsPerMm)));
    }
}

