/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.builders;

import com.zortrax.g2z.domain.GCode;
import com.zortrax.g2z.domain.builders.ZCommandBuilder;
import com.zortrax.g2z.domain.data.ActiveExtruder;
import com.zortrax.g2z.domain.zcodeCommands.CmdSetHotendTemperature;
import com.zortrax.g2z.domain.zcodeCommands.CmdWaitForHeating;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.context.annotation.Description;
import org.springframework.stereotype.Component;

@Description(value="Wait for heating hotend command builder")
@Component
public class GCodeWaitForHotendHeatingBuilder
implements ZCommandBuilder {
    public Stream<ZCommand> toZCode(GCode gcode) {
        BigDecimal temperature;
        if (gcode.getValue("S").isPresent()) {
            temperature = (BigDecimal)gcode.getValue("S").get();
        } else if (gcode.getValue("R").isPresent()) {
            temperature = (BigDecimal)gcode.getValue("R").get();
        } else {
            return Stream.of(new CmdWaitForHeating());
        }
        int hotendId = gcode.getValue("T").map(BigDecimal::intValue).orElse(ActiveExtruder.getInstance().getId());
        return Stream.builder().add(Optional.of(new CmdSetHotendTemperature(hotendId, temperature))).add(Optional.of(new CmdWaitForHeating())).build().map(Optional::get);
    }

    public boolean accept(GCode gCode) {
        return gCode.isCommandType("M109");
    }
}

