/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.builders;

import com.zortrax.g2z.domain.GCode;
import com.zortrax.g2z.domain.builders.ZCommandBuilder;
import com.zortrax.g2z.domain.data.CurrentDeviceConfig;
import com.zortrax.g2z.domain.data.IDeviceConfig;
import com.zortrax.g2z.domain.zcodeCommands.CmdSetBedTemperature;
import com.zortrax.g2z.domain.zcodeCommands.CmdSetChamberTemperature;
import com.zortrax.g2z.domain.zcodeCommands.CmdWaitForHeating;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.context.annotation.Description;
import org.springframework.stereotype.Component;

@Description(value="Wait for chamber heating")
@Component
public class GCodeWaitForChamberHeatingBuilder
implements ZCommandBuilder {
    public Stream<ZCommand> toZCode(GCode gcode) {
        BigDecimal temperature;
        if (gcode.getValue("S").isPresent()) {
            temperature = (BigDecimal)gcode.getValue("S").get();
        } else if (gcode.getValue("R").isPresent()) {
            temperature = (BigDecimal)gcode.getValue("R").get();
        } else {
            return Stream.of(new CmdWaitForHeating());
        }
        CmdSetChamberTemperature object = new CmdSetChamberTemperature(temperature);
        IDeviceConfig config = CurrentDeviceConfig.getDeviceConfig();
        if (config != null && config.platformIsChamber()) {
            object = new CmdSetBedTemperature(temperature);
        }
        return Stream.builder().add(Optional.of(object)).add(Optional.of(new CmdWaitForHeating())).build().map(Optional::get);
    }

    public boolean accept(GCode gCode) {
        return gCode.isCommandType("M191");
    }
}

