/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.builders;

import com.zortrax.g2z.domain.GCode;
import com.zortrax.g2z.domain.builders.ZCommandBuilder;
import com.zortrax.g2z.domain.zcodeCommands.CmdSetBedTemperature;
import com.zortrax.g2z.domain.zcodeCommands.CmdWaitForHeating;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.context.annotation.Description;
import org.springframework.stereotype.Component;

@Description(value="Set bed temperature and wait for heating")
@Component
public class GCodeWaitForBedHeatingBuilder
implements ZCommandBuilder {
    public Stream<ZCommand> toZCode(GCode gcode) {
        BigDecimal temperature;
        if (gcode.getValue("S").isPresent()) {
            temperature = (BigDecimal)gcode.getValue("S").get();
        } else if (gcode.getValue("R").isPresent()) {
            temperature = (BigDecimal)gcode.getValue("R").get();
        } else {
            return Stream.of(new CmdWaitForHeating());
        }
        return Stream.builder().add(Optional.of(new CmdSetBedTemperature(temperature))).add(Optional.of(new CmdWaitForHeating())).build().map(Optional::get);
    }

    public boolean accept(GCode gCode) {
        return gCode.isCommandType("M190");
    }
}

