/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.builders;

import com.zortrax.g2z.domain.GCode;
import com.zortrax.g2z.domain.builders.ZCommandBuilder;
import com.zortrax.g2z.domain.data.AxisFields;
import com.zortrax.g2z.domain.data.AxisFix;
import com.zortrax.g2z.domain.data.EstimatePrintingTime;
import com.zortrax.g2z.domain.zcodeCommands.CmdSetAsValue;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.context.annotation.Description;
import org.springframework.stereotype.Component;

@Description(value="Set position command builder")
@Component
public class GCodeSetPositionBuilder
implements ZCommandBuilder {
    public Stream<ZCommand> toZCode(GCode gcode) {
        EstimatePrintingTime.getInstance().setCurrentXYZE(gcode.getValue("X"), gcode.getValue("Y"), gcode.getValue("Z"), gcode.getValue("E"));
        AxisFix.getInstance().setCurrentXYZE(gcode.getValue("X"), gcode.getValue("Y"), gcode.getValue("Z"), gcode.getValue("E"));
        return Stream.builder().add(Optional.of(Stream.of(gcode.getValue("X"), gcode.getValue("Y"), gcode.getValue("Z"), gcode.getValue("Z2"), gcode.getValue("E"), gcode.getValue("A"), gcode.getValue("B")).findAny()).map(any -> new CmdSetAsValue(new AxisFields().setAxisX(gcode.getValue("X")).setAxisY(gcode.getValue("Y")).setAxisZ(gcode.getValue("Z")).setAxisZ2(gcode.getValue("Z2")).setExtrudeAmount(gcode.getValue("E")).setFan1(gcode.getValue("A")).setFan2(gcode.getValue("B"))))).build().filter(Optional::isPresent).map(Optional::get);
    }

    public boolean accept(GCode gCode) {
        return gCode.isCommandType("G92");
    }
}

