/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.builders;

import com.zortrax.g2z.domain.GCode;
import com.zortrax.g2z.domain.builders.MissingRequiredParameter;
import com.zortrax.g2z.domain.builders.ZCommandBuilder;
import com.zortrax.g2z.domain.zcodeCommands.CmdSetLayer;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.context.annotation.Description;
import org.springframework.stereotype.Component;

@Description(value="Set Layer command builder")
@Component
public class GCodeSetLayerBuilder
implements ZCommandBuilder {
    private final String CommentName = "LAYER";

    public Stream<ZCommand> toZCode(GCode gcode) {
        if (gcode.isCommentType("LAYER")) {
            Optional value = gcode.getCommentValue();
            return value.map(bigDecimal -> Stream.of(new CmdSetLayer(bigDecimal))).orElseGet(Stream::empty);
        }
        return Stream.of(new CmdSetLayer((BigDecimal)gcode.getValue("N").orElseThrow(() -> new MissingRequiredParameter("M110 required layer number", gcode))));
    }

    public boolean accept(GCode gCode) {
        return gCode.isCommandType("M110") || gCode.isCommentType("LAYER");
    }
}

