/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.builders;

import com.zortrax.g2z.domain.GCode;
import com.zortrax.g2z.domain.builders.MissingRequiredParameter;
import com.zortrax.g2z.domain.builders.ZCommandBuilder;
import com.zortrax.g2z.domain.data.ActiveExtruder;
import com.zortrax.g2z.domain.zcodeCommands.CmdSetHotendTemperature;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.math.BigDecimal;
import java.util.stream.Stream;
import org.springframework.context.annotation.Description;
import org.springframework.stereotype.Component;

@Description(value="Set hotend temperature command builder")
@Component
public class GCodeSetHotendTemperatureBuilder
implements ZCommandBuilder {
    public Stream<ZCommand> toZCode(GCode gcode) {
        if (!gcode.getValue("S").isPresent()) {
            return null;
        }
        BigDecimal temperature = (BigDecimal)gcode.getValue("S").orElseThrow(() -> new MissingRequiredParameter("M104Builder required temperature", gcode));
        int hotendId = gcode.getValue("T").map(BigDecimal::intValue).orElse(ActiveExtruder.getInstance().getId());
        return Stream.of(new CmdSetHotendTemperature(hotendId, temperature));
    }

    public boolean accept(GCode gCode) {
        return gCode.isCommandType("M104");
    }
}

