/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.builders;

import com.zortrax.g2z.domain.GCode;
import com.zortrax.g2z.domain.builders.MissingRequiredParameter;
import com.zortrax.g2z.domain.builders.ZCommandBuilder;
import com.zortrax.g2z.domain.data.CurrentDeviceConfig;
import com.zortrax.g2z.domain.data.IDeviceConfig;
import com.zortrax.g2z.domain.zcodeCommands.CmdSetBedTemperature;
import com.zortrax.g2z.domain.zcodeCommands.CmdSetChamberTemperature;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.math.BigDecimal;
import java.util.stream.Stream;
import org.springframework.context.annotation.Description;
import org.springframework.stereotype.Component;

@Description(value="Set chamber temperature command builder")
@Component
public class GCodeSetChamberTemperatureBuilder
implements ZCommandBuilder {
    public Stream<ZCommand> toZCode(GCode gcode) {
        BigDecimal value = (BigDecimal)gcode.getValue("S").orElseThrow(() -> new MissingRequiredParameter("M141 required temperature", gcode));
        IDeviceConfig config = CurrentDeviceConfig.getDeviceConfig();
        if (config != null && config.platformIsChamber()) {
            return Stream.of(new CmdSetBedTemperature(value));
        }
        return Stream.of(new CmdSetChamberTemperature(value));
    }

    public boolean accept(GCode gCode) {
        return gCode.isCommandType("M141");
    }
}

