/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.builders;

import com.zortrax.g2z.domain.GCode;
import com.zortrax.g2z.domain.builders.MissingRequiredParameter;
import com.zortrax.g2z.domain.builders.ZCommandBuilder;
import com.zortrax.g2z.domain.zcodeCommands.CmdSetBedTemperature;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.math.BigDecimal;
import java.util.stream.Stream;
import org.springframework.context.annotation.Description;
import org.springframework.stereotype.Component;

@Description(value="Set bed temperature command builder")
@Component
public class GCodeSetBedTemperatureBuilder
implements ZCommandBuilder {
    public Stream<ZCommand> toZCode(GCode gcode) {
        return Stream.of(new CmdSetBedTemperature((BigDecimal)gcode.getValue("S").orElseThrow(() -> new MissingRequiredParameter("M140 required temperature", gcode))));
    }

    public boolean accept(GCode gCode) {
        return gCode.isCommandType("M140");
    }
}

