/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.builders;

import com.zortrax.g2z.domain.GCode;
import com.zortrax.g2z.domain.builders.ZCommandBuilder;
import com.zortrax.g2z.domain.data.AxisFields;
import com.zortrax.g2z.domain.data.AxisFix;
import com.zortrax.g2z.domain.data.EstimatePrintingTime;
import com.zortrax.g2z.domain.zcodeCommands.CmdAbsolutePositioning;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.context.annotation.Description;
import org.springframework.stereotype.Component;

@Description(value="Set absolute positioning")
@Component
public class GCodeSetAbsolutePositioning
implements ZCommandBuilder {
    public static final BigDecimal AXIS_ZERO = BigDecimal.valueOf(0L);
    private AxisFields axisFields;

    public Stream<ZCommand> toZCode(GCode gcode) {
        EstimatePrintingTime.getInstance().setRelative(false);
        AxisFix.getInstance().setRelative(false);
        return Stream.of((ZCommand)Optional.of(this.createCmd(gcode)).filter(axis -> this.axisFields.anyAxisExist()).orElseGet(this.createDefault()));
    }

    private Supplier<CmdAbsolutePositioning> createDefault() {
        return () -> new CmdAbsolutePositioning(new AxisFields(AXIS_ZERO, AXIS_ZERO, AXIS_ZERO, AXIS_ZERO, AXIS_ZERO, AXIS_ZERO, AXIS_ZERO));
    }

    private CmdAbsolutePositioning createCmd(GCode gcode) {
        this.axisFields = new AxisFields().setAxisX(gcode.getValue("X")).setAxisY(gcode.getValue("Y")).setAxisZ(gcode.getValue("Z")).setAxisZ2(gcode.getValue("Z2")).setExtrudeAmount(gcode.getValue("E")).setFan1(gcode.getValue("Fan1")).setFan2(gcode.getValue("Fan2"));
        return new CmdAbsolutePositioning(this.axisFields);
    }

    public boolean accept(GCode gCode) {
        return gCode.isCommandType("G90");
    }
}

