/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.builders;

import com.zortrax.g2z.domain.GCode;
import com.zortrax.g2z.domain.builders.MissingRequiredParameter;
import com.zortrax.g2z.domain.builders.ZCommandBuilder;
import com.zortrax.g2z.domain.data.ActiveExtruder;
import com.zortrax.g2z.domain.data.EstimatePrintingTime;
import com.zortrax.g2z.domain.data.SpecialPosition;
import com.zortrax.g2z.domain.zcodeCommands.CmdMoveToSpecialPosition;
import com.zortrax.g2z.domain.zcodeCommands.CmdSelectExtruder;
import com.zortrax.g2z.domain.zcodeCommands.CmdSetFeedrate;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.context.annotation.Description;
import org.springframework.stereotype.Component;

@Description(value="Select Extruder command builder")
@Component
public class GCodeSelectExtruderBuilder
implements ZCommandBuilder {
    public Stream<ZCommand> toZCode(GCode gcode) {
        BigDecimal extruderNumber = (BigDecimal)gcode.getValue("T").orElseThrow(() -> new MissingRequiredParameter("TX required extruder number", gcode));
        EstimatePrintingTime.getInstance().selectExtruder(extruderNumber);
        ActiveExtruder.getInstance().setId(extruderNumber.intValue());
        SpecialPosition fastPosition = SpecialPosition.SP_EXTRUDER_SWITCHING_TO_MODEL_FAST;
        SpecialPosition slowPosition = SpecialPosition.SP_EXTRUDER_SWITCHING_TO_MODEL_SLOW;
        if (extruderNumber.equals(BigDecimal.valueOf(1L))) {
            fastPosition = SpecialPosition.SP_EXTRUDER_SWITCHING_TO_SUPPORT_FAST;
            slowPosition = SpecialPosition.SP_EXTRUDER_SWITCHING_TO_SUPPORT_SLOW;
        }
        return Stream.builder().add(Optional.of(new CmdSetFeedrate(BigDecimal.valueOf(7200L)))).add(Optional.of(new CmdMoveToSpecialPosition(fastPosition))).add(Optional.of(new CmdSetFeedrate(BigDecimal.valueOf(500L)))).add(Optional.of(new CmdMoveToSpecialPosition(slowPosition))).add(Optional.of(new CmdSelectExtruder(extruderNumber))).build().map(Optional::get);
    }

    public boolean accept(GCode gCode) {
        return gCode.isCommandType("T0") || gCode.isCommandType("T1");
    }
}

