/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.builders;

import com.zortrax.g2z.domain.GCode;
import com.zortrax.g2z.domain.builders.MissingRequiredParameter;
import com.zortrax.g2z.domain.builders.ZCommandBuilder;
import com.zortrax.g2z.domain.data.SpecialPosition;
import com.zortrax.g2z.domain.zcodeCommands.CmdMoveToSpecialPosition;
import com.zortrax.g2z.domain.zcodeCommands.CmdSetFeedrate;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.stereotype.Component;

@Component
public class GCodeMoveToSpecialPosition
implements ZCommandBuilder {
    public Stream<ZCommand> toZCode(GCode gcode) {
        BigDecimal id = (BigDecimal)gcode.getValue("T").orElseThrow(() -> new MissingRequiredParameter("M190 required parameter", gcode));
        return Stream.builder().add(gcode.getValue("F").map(f -> new CmdSetFeedrate(f))).add(Optional.of(new CmdMoveToSpecialPosition(SpecialPosition.fromValue((byte)id.byteValue())))).build().map(Optional::get);
    }

    public boolean accept(GCode gCode) {
        return gCode.isCommandType("G101");
    }
}

