/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain.builders;

import com.zortrax.g2z.domain.GCode;
import com.zortrax.g2z.domain.builders.ZCommandBuilder;
import com.zortrax.g2z.domain.data.EstimatePrintingTime;
import com.zortrax.g2z.domain.zcodeCommands.CmdSleep;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.context.annotation.Description;
import org.springframework.stereotype.Component;

@Description(value="Delay command builder")
@Component
public class GCodeDelayBuilder
implements ZCommandBuilder {
    public Stream<ZCommand> toZCode(GCode gcode) {
        return Stream.of((ZCommand)this.createCommandForSParameter(gcode).orElse(this.createCommandForPParameter(gcode).orElse(this.createDefault())));
    }

    private Optional<CmdSleep> createCommandForSParameter(GCode gcode) {
        if (gcode.getValue("S").isPresent()) {
            EstimatePrintingTime.getInstance().addDelay((BigDecimal)gcode.getValue("S").get());
        }
        return Optional.of(gcode.getValue("S")).filter(Optional::isPresent).map(v -> new CmdSleep(new BigDecimal(((BigDecimal)v.get()).intValue() * 1000)));
    }

    private Optional<CmdSleep> createCommandForPParameter(GCode gcode) {
        if (gcode.getValue("P").isPresent()) {
            EstimatePrintingTime.getInstance().addDelay(((BigDecimal)gcode.getValue("P").get()).divide(BigDecimal.valueOf(1000L)));
        }
        return Optional.of(gcode.getValue("P")).filter(Optional::isPresent).map(v -> new CmdSleep((BigDecimal)v.get()));
    }

    private CmdSleep createDefault() {
        return new CmdSleep(new BigDecimal(0));
    }

    public boolean accept(GCode gCode) {
        return gCode.isCommandType("G4");
    }
}

