/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain;

import java.math.BigDecimal;
import java.util.Optional;

public class GCode {
    String cmd;

    public GCode(String cmd) {
        this.cmd = cmd;
    }

    public boolean isCommandType(String arg) {
        return this.cmd.startsWith(arg + " ") || this.cmd.equals(arg);
    }

    public boolean isCommentType(String arg) {
        return this.cmd.startsWith(";" + arg + ":");
    }

    public Optional<String> getComment() {
        int beginIndex = this.cmd.indexOf("<");
        int endIndex = this.cmd.indexOf(">");
        if (beginIndex >= 0 && endIndex > 0) {
            return Optional.of(this.cmd.substring(beginIndex + 1, endIndex));
        }
        return Optional.of("Unknown");
    }

    public Optional<BigDecimal> getValue(String valueType) {
        String cleanCommand = this.cmd.indexOf(";") > 0 ? this.cmd.substring(0, this.cmd.indexOf(";")) : this.cmd;
        int startIndex = cleanCommand.indexOf(valueType);
        int endIndex = cleanCommand.indexOf(" ", this.cmd.indexOf(valueType));
        if (!cleanCommand.contains(valueType) || startIndex < 0) {
            return Optional.empty();
        }
        String substring = cleanCommand.substring(startIndex + 1, endIndex > 0 ? endIndex : cleanCommand.length()).trim();
        if (substring.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new BigDecimal(substring));
    }

    public Optional<BigDecimal> getCommentValue() {
        return this.getValue(":");
    }

    public String toString() {
        return "GCode{cmd='" + this.cmd + '\'' + '}';
    }
}

