/*
 * Decompiled with CFR 0.152.
 */
package com.zortrax.g2z.domain;

import com.zortrax.g2z.domain.GCode;
import com.zortrax.g2z.domain.builders.ZCommandBuilder;
import com.zortrax.g2z.domain.helper.ByteCollector;
import com.zortrax.g2z.domain.zcodeCommands.ZCommand;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class G2ZParser {
    @Autowired
    List<ZCommandBuilder> commandList;

    public List<ZCommand> parse(List<String> fileList) {
        return fileList.stream().flatMap(s -> this.convert(new GCode(s))).collect(Collectors.toList());
    }

    private Stream<ZCommand> convert(GCode gCode) {
        return this.commandList.stream().filter(zCommandBuilder -> zCommandBuilder.accept(gCode)).flatMap(zCommandBuilder -> zCommandBuilder.toZCode(gCode));
    }

    public byte[] doAll(List<String> fileList) {
        return (byte[])fileList.stream().flatMap(s -> this.convert(new GCode(s))).collect(ByteCollector.zCommandtoArray());
    }
}

